#define RECORDERNAME "MP3 Recorder"

#include "recorder.h"
#include "BladeMP3EncDLL.h"
#include "resource.h"
  

class rec : public COOERecorder {
public:
	virtual bool __cdecl Init();

	virtual bool __cdecl IsMultiTrack() { return false; };
	virtual bool __cdecl IsTagged() { return false; };
	virtual bool __cdecl IsStreamed() { return false; };
	virtual bool __cdecl IsRequiresWaveout() { return false; };
	virtual bool __cdecl IsLossyCompression() { return false; };

	virtual bool __cdecl IsSampleRateChangeable() { return false; };
	virtual bool __cdecl SampleRateChanged(int samplerate) { return false; };
	virtual bool __cdecl IsBitRateChangeable() { return false; };
	virtual bool __cdecl BitRateChanged(int bitrate) { return false; };

	virtual bool __cdecl SupportsSampleRate(int samplerate) { return true; };
	virtual bool __cdecl SupportsBitRate(int bitrate) { return true; };

	virtual bool __cdecl SaveAs(HWND parentwindow);
	virtual bool __cdecl ReadyToRec();

	virtual bool __cdecl TrackNames(int track_id, char *track_name) { return false; };
	virtual bool __cdecl SongTagData(int tag_index, char *tagdata) { return false; };

    virtual bool __cdecl Start(char * filename, int samplespersec);
    virtual bool __cdecl WorkOutput(float *psamples, int numsamples);
	virtual bool __cdecl WorkOutputMulti(int track_id, float *psamples, int numsamples) { return false; };

    virtual bool __cdecl Finish();
    virtual void __cdecl ConfigDlg(HWND parentwindow);
	virtual void __cdecl DispatchCommand(int command_id, int param1, int param2, int param3, int param4);
	virtual void __cdecl DispatchCommandEx(char * str_command, char * str_value);

	virtual void __cdecl LoadSettings(char * settingsname, char *username, char *domain) { };
	virtual void __cdecl SaveSettings(char * settingsname, char *username, char *domain) { };

	virtual char * __cdecl OutputFilename();
    virtual char * __cdecl OutputSize();
	virtual char * __cdecl ExtraInfo(int extra_info_id) { return "No Extra Info"; };
	virtual char * __cdecl RecordersWebSiteURL() { return "http://www.buzzscene.ca"; };

	virtual int __cdecl RecorderVersion() { return 100; };

	virtual void GetRecorderExtensionsClass(int param, void **exmodule) { };
public:
	char myfilename[255];
	FILE * myfilehandle;
	int writtensofar;

	HMODULE				lamedll;
	BEINITSTREAM		beInitStream;
	BEENCODECHUNK		beEncodeChunk;
	BEDEINITSTREAM		beDeinitStream;
	BECLOSESTREAM		beCloseStream;
	BEVERSION			beVersion;
	BEWRITEVBRHEADER	beWriteVBRHeader;
	BE_CONFIG			beConfig;
	BE_VERSION			Version;
	DWORD				dwSamples;
	DWORD				dwMP3Buffer;
	HBE_STREAM			hbeStream;
	BE_ERR				err;
	PBYTE				pMP3Buffer;
	PSHORT				pWAVBuffer;

	DWORD dwRead;
	DWORD dwWrite;
	DWORD dwDone;
	DWORD dwFileSize;

	int outputbitrate;
	int outputvbr;
	int outputmode;
	int ismonoout;
};

char myappdir[255];

bool rec::Init(){
	char strbuf[255];
	// Normal LameDLL stuff

	{
		// first spot
		sprintf(strbuf, "%s\\Gear\\Recorders\\lame_enc.dll", myappdir);
		lamedll = LoadLibrary(strbuf);
	}
	if(lamedll==NULL)
	{
		// first spot in a different format
		lamedll = LoadLibrary(".\\Gear\\Recorders\\lame_enc.dll");
	}
	if(lamedll==NULL)
	{
		// second spot
		sprintf(strbuf, "%s\\Gear\\lame_enc.dll", myappdir);
		lamedll = LoadLibrary(strbuf);
	}
	if(lamedll==NULL)
	{
		// third spot
		sprintf(strbuf, "%s\\lame_enc.dll", myappdir);
		lamedll = LoadLibrary(strbuf);
	}
	if(lamedll==NULL)
	{
		// all other spots
		lamedll = LoadLibrary("lame_enc.dll");
	}
		
	if(lamedll==NULL)
	{
		MessageBox(NULL,"Error loading lame_enc.DLL", "Error", MB_OK);
		return false;
	}

	beInitStream	= (BEINITSTREAM) GetProcAddress(lamedll, TEXT_BEINITSTREAM);
	beEncodeChunk	= (BEENCODECHUNK) GetProcAddress(lamedll, TEXT_BEENCODECHUNK);
	beDeinitStream	= (BEDEINITSTREAM) GetProcAddress(lamedll, TEXT_BEDEINITSTREAM);
	beCloseStream	= (BECLOSESTREAM) GetProcAddress(lamedll, TEXT_BECLOSESTREAM);
	beVersion		= (BEVERSION) GetProcAddress(lamedll, TEXT_BEVERSION);
	beWriteVBRHeader= (BEWRITEVBRHEADER) GetProcAddress(lamedll,TEXT_BEWRITEVBRHEADER);

	sprintf(myfilename, "");
	myfilehandle = NULL;
	writtensofar = 0;
	outputbitrate = 8;
	outputvbr = 0;
	outputmode = 1;
	return true;
}
bool rec::SaveAs(HWND parentwindow){
	OPENFILENAME ofl;
	char filename[255];
	int nSuccess;

	sprintf(filename,"untitled.mp3");
	ofl.lStructSize = sizeof(ofl);
	ofl.hwndOwner = parentwindow;
	ofl.hInstance = dllInstance;
	ofl.lpstrFilter = "MP3 Music Format (*.mp3)\0*.mp3\0";
	ofl.lpstrCustomFilter = NULL;
	ofl.nMaxCustFilter = NULL;
	ofl.nFilterIndex = 1;
	ofl.lpstrFile = filename;
	ofl.nMaxFile = 255;
	ofl.lpstrFileTitle = NULL;
	ofl.nMaxFileTitle = NULL;
	ofl.lpstrInitialDir = NULL;
	ofl.lpstrTitle = "Save Song Output as";
	ofl.Flags = OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST;
	ofl.nFileOffset = 0;
	ofl.nFileExtension = 0;
	ofl.lpstrDefExt = ".mp3";
	ofl.lCustData = NULL;
	ofl.lpfnHook = NULL;
	ofl.lpTemplateName = NULL;
	nSuccess = GetSaveFileName(&ofl);
	if (nSuccess == 0) {
		sprintf(myfilename, "");
//		SetWindowText(GetDlgItem(hDlg, IDC_FILENAMEBTN), "Save As...");
	} else {
		sprintf(myfilename, ofl.lpstrFile);
//		SetWindowText(GetDlgItem(hDlg, IDC_FILENAMEBTN), ext_hdfilename);
	}
	return true;
}
char *rec::OutputFilename() {
	return myfilename;
}
bool rec::Start (char * filename, int samplespersec) {
	int n = 128;

	myfilehandle = fopen(filename, "wb");

	memset(&beConfig,0,sizeof(beConfig));					// clear all fields
	beConfig.dwConfig = BE_CONFIG_LAME;
	beConfig.format.LHV1.dwStructVersion	= 1;
	beConfig.format.LHV1.dwStructSize		= sizeof(beConfig);		
	beConfig.format.LHV1.dwSampleRate		= samplespersec;		// INPUT FREQUENCY
	beConfig.format.LHV1.dwReSampleRate		= 0;					// DON"T RESAMPLE

	switch (outputmode)
	{
	case 0: beConfig.format.LHV1.nMode = BE_MP3_MODE_STEREO; ismonoout=0; break;
	case 1: beConfig.format.LHV1.nMode = BE_MP3_MODE_JSTEREO; ismonoout=0; break;
	case 2: beConfig.format.LHV1.nMode = BE_MP3_MODE_DUALCHANNEL; ismonoout=0; break;
	case 3: beConfig.format.LHV1.nMode = BE_MP3_MODE_MONO; ismonoout=1; break;
	default: beConfig.format.LHV1.nMode = BE_MP3_MODE_JSTEREO; ismonoout=0; break;
	}

	switch (outputbitrate)
	{
	case 0: beConfig.format.LHV1.dwBitrate = 32; n = 40; break;
	case 1: beConfig.format.LHV1.dwBitrate = 40; n = 48; break;
	case 2: beConfig.format.LHV1.dwBitrate = 48; n = 56; break;
	case 3: beConfig.format.LHV1.dwBitrate = 56; n = 64; break;
	case 4: beConfig.format.LHV1.dwBitrate = 64; n = 80; break;
	case 5: beConfig.format.LHV1.dwBitrate = 80; n = 96; break;
	case 6: beConfig.format.LHV1.dwBitrate = 96; n = 112; break;
	case 7: beConfig.format.LHV1.dwBitrate = 112; n = 128; break;
	case 8: beConfig.format.LHV1.dwBitrate = 128; n = 160; break;
	case 9: beConfig.format.LHV1.dwBitrate = 160; n = 192; break;
	case 10: beConfig.format.LHV1.dwBitrate = 192; n = 224; break;
	case 11: beConfig.format.LHV1.dwBitrate = 224; n = 256; break;
	case 12: beConfig.format.LHV1.dwBitrate = 256; n = 320; break;
	case 13: beConfig.format.LHV1.dwBitrate = 320; n = 320; break;
	default: beConfig.format.LHV1.dwBitrate = 128; n = 160; break;
	}

	if (outputvbr == 1) {
		beConfig.format.LHV1.bEnableVBR     = TRUE;
		beConfig.format.LHV1.dwVbrAbr_bps = beConfig.format.LHV1.dwBitrate;
		beConfig.format.LHV1.dwMaxBitrate = n;
	} else {
//		beConfig.format.LHV1.bEnableVBR     = FALSE;
	}
	beConfig.format.LHV1.nPreset			= LQP_HIGH_QUALITY;		// QUALITY PRESET SETTING
	beConfig.format.LHV1.dwMpegVersion		= MPEG1;				// MPEG VERSION (I or II)
	beConfig.format.LHV1.dwPsyModel			= 0;					// USE DEFAULT PSYCHOACOUSTIC MODEL 
	beConfig.format.LHV1.dwEmphasis			= 0;					// NO EMPHASIS TURNED ON
	beConfig.format.LHV1.bOriginal			= TRUE;					// SET ORIGINAL FLAG

	beInitStream(&beConfig, &dwSamples, &dwMP3Buffer, &hbeStream);

	pMP3Buffer = new BYTE[dwMP3Buffer];
	pWAVBuffer = new SHORT[dwSamples];

	dwRead=0;
	dwWrite=0;
	dwDone=0;
	dwFileSize=0;
	
	writtensofar = 0;
	return true;
}
bool rec::ReadyToRec() {
	if (strcmp(myfilename, "") == 0) {
		return false;
	} else {
		return true;
	}

}

bool rec::WorkOutput (float *psamples, int numsamples) {
	short psampsm[1024];
	if (ismonoout == 1) {
		int u = 0;
		for (int i = 0; i < (numsamples * 2); i++) {
			if (psamples[i] > 32767.0f) psamples[i] = 32767.0f;
			if (psamples[i] < -32766.0f) psamples[i] = -32766.0f;
			i++;
			if (psamples[i] > 32767.0f) psamples[i] = 32767.0f;
			if (psamples[i] < -32766.0f) psamples[i] = -32766.0f;
			psampsm[u] = (short)((psamples[i]+psamples[i-1])*0.5f);
			u++;
		}
		//writtensofar += numsamples;
		dwRead = numsamples;
		// Encode samples
		beEncodeChunk(hbeStream, dwRead, psampsm, pMP3Buffer, &dwWrite);
		fwrite(pMP3Buffer,1,dwWrite,myfilehandle);
		writtensofar += dwWrite;

	} else {
		for (int i = 0; i < (numsamples * 2); i++) {
			if (psamples[i] > 32767.0f) psamples[i] = 32767.0f;
			if (psamples[i] < -32766.0f) psamples[i] = -32766.0f;
			psampsm[i] = (short)psamples[i];
		}
		//writtensofar += numsamples;
		dwRead = numsamples * 2;
		// Encode samples
		beEncodeChunk(hbeStream, dwRead, psampsm, pMP3Buffer, &dwWrite);
		fwrite(pMP3Buffer,1,dwWrite,myfilehandle);
		writtensofar += dwWrite;
	}
	return true;
}

bool rec::Finish() {
	err = beDeinitStream(hbeStream, pMP3Buffer, &dwWrite);

	if(dwWrite)
	{
		if(fwrite(pMP3Buffer,1,dwWrite,myfilehandle) != dwWrite)
		{
			//fprintf(stderr,"Output file write error");
			//return false;
		}
	}

	beCloseStream(hbeStream);
	delete [] pWAVBuffer;
	delete [] pMP3Buffer;


	fflush(myfilehandle);
	fclose(myfilehandle);

	if (outputvbr == 1) {
		// Write the VBR Tag
		beWriteVBRHeader(myfilename);
	}

	return true;
}

char * rec::OutputSize() {
	static char megs[32];
	sprintf(megs, "%.2fM", ((float)writtensofar / 1024.0f / 1024.0f));
	return megs;
}

rec *prec;

BOOL APIENTRY ConfigDialog (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
	{
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_RESETCONTENT, 0, 0);
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("32"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("40"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("48"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("56"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("64"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("80"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("96"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("112"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("128"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("160"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("192"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("224"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("256"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("320"));
		SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_SETCURSEL, (int)(prec->outputbitrate), 0);

		SendMessage(GetDlgItem(hDlg, IDC_BRTYPE), CB_RESETCONTENT, 0, 0);
		SendMessage(GetDlgItem(hDlg, IDC_BRTYPE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("CBR"));
		SendMessage(GetDlgItem(hDlg, IDC_BRTYPE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("VBR"));
		SendMessage(GetDlgItem(hDlg, IDC_BRTYPE), CB_SETCURSEL, (int)(prec->outputvbr), 0);

		SendMessage(GetDlgItem(hDlg, IDC_CHMODE), CB_RESETCONTENT, 0, 0);
		SendMessage(GetDlgItem(hDlg, IDC_CHMODE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_CHMODE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("Joint Stereo"));
		SendMessage(GetDlgItem(hDlg, IDC_CHMODE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("Dual Channel"));
		SendMessage(GetDlgItem(hDlg, IDC_CHMODE), CB_ADDSTRING,0,(LPARAM)(LPCTSTR)("Mono"));
		SendMessage(GetDlgItem(hDlg, IDC_CHMODE), CB_SETCURSEL, (int)(prec->outputmode), 0);

		return 1;
	}
	case WM_SHOWWINDOW:
	{
		return 1;
	}
	case WM_CLOSE:
	{
		EndDialog (hDlg, TRUE);
	}
	case WM_COMMAND:
		switch ( LOWORD (wParam))
		{
		case IDOK:
			
			prec->outputbitrate = (int)SendMessage(GetDlgItem(hDlg, IDC_BITRATE), CB_GETCURSEL, 0, 0);
			prec->outputvbr     = (int)SendMessage(GetDlgItem(hDlg, IDC_BRTYPE), CB_GETCURSEL, 0, 0);
			prec->outputmode    = (int)SendMessage(GetDlgItem(hDlg, IDC_CHMODE), CB_GETCURSEL, 0, 0);

			EndDialog (hDlg, TRUE);
			break;
		case IDCANCEL:
			EndDialog (hDlg, TRUE);
			break;
		default:
			return 0;
		}
		break;
	}
	return 0;
}

BOOL APIENTRY AboutDialog (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
	{
		return 1;
	}
	case WM_SHOWWINDOW:
	{
		return 1;
	}
	case WM_CLOSE:
	{
		EndDialog (hDlg, TRUE);
	}
	case WM_COMMAND:
		switch ( LOWORD (wParam))
		{
		case IDOK:
			EndDialog (hDlg, TRUE);
			break;
		case IDCANCEL:
			EndDialog (hDlg, TRUE);
			break;
		default:
			return 0;
		}
		break;
	}
	return 0;
}

void rec::ConfigDlg (HWND parentwindow) {
	prec = this;
	DialogBox(dllInstance, MAKEINTRESOURCE (IDD_CONFIG), parentwindow, (DLGPROC) &ConfigDialog);
}

void rec::DispatchCommand(int command_id, int param1, int param2, int param3, int param4) {

}

void rec::DispatchCommandEx(char * str_command, char * str_value) {
	if (strcmp(str_command, "about") == 0) {
		// str_value is actually a pointer 
		// to the parent HWND in this case
		HWND parentwindow = *(HWND*)str_value; 
		DialogBox(dllInstance, MAKEINTRESOURCE (IDD_ABOUT), parentwindow, (DLGPROC) &AboutDialog);
	}
}

EXPORTTHING

BOOL WINAPI DllMain ( HANDLE hModule, DWORD fwdreason, LPVOID lpReserved )
{
	switch (fwdreason) {
	case DLL_PROCESS_ATTACH: { 
		char baba[256], baba2[256];
		char *filen;
		dllInstance = (HINSTANCE) hModule; 
		GetModuleFileName(dllInstance,baba,256);
		GetFullPathName(baba,256,baba2,&filen);
		sprintf(filen,"\0");
		sprintf(&baba2[(int)(strlen(baba2) - 2 - 14)],"\0");
		sprintf(myappdir,baba2);
	} break;
	case DLL_THREAD_ATTACH: break;
	case DLL_THREAD_DETACH: break;
	case DLL_PROCESS_DETACH: break;
	}
	return TRUE;
}
